//*****************************************************************************
// File Name	: motortest.c
// 
// Title		: example usage of motor library functions
// Revision		: 2.3
// Notes		:	
// Target MCU	: Atmel AVR mega32 (KR-mega32-16v23)
// Editor Tabs	: 4
// 
// Revision History:
// When			Who			Description of change
// -----------	-----------	-----------------------
// 09-Dez-2004	krat		Created the program
//*****************************************************************************

/*
			Funktionsbeschreibung
	
Das Programm lsst die beiden Motoren laufen. Dabei hngt die Geschwindigkeit und Richtung 
von der Eingangsspannung am Analogport 2 ab.
Schlieen Sie an die Motorausgnge je einen Motor (nicht mehr als 600 mA) und an den Analogport
1 ein Poti oder Abstandssensor oder etwas anderes, was ein analoges Signal zurck gibt an.

Viel Erfolg

Thomas Krause (krat)
Krause Robotik

mailto: thomas.krause@krause-robotik.de

*/ 
 
//----- Include Files ---------------------------------------------------------
#include "kr-mega32v23.h"		// include Library support

void pulseTest(void);

//----- Begin Code ------------------------------------------------------------
int main(void)
{
	// initialize our libraries
	// initialize the timer
	timerInit();
	// initialize the motor outputs
	motorInit();
	
	// initialize the LCD
	lcdInit();
	// initialize rprintf system for LCD output
	rprintfInit(lcdDataWrite);
	// initialize our analog compare units
	a2dInit();
	
	// run the test
	pulseTest();


	return 0;
}

void pulseTest(void)
{
	// start endless loop
	while(1)
	{
		// set LCD cursor to position 0,0
		lcdGotoXY(0, 0);
		rprintf("%d    ", analog(2));
		
		motor(1, (50 - analog(2)) * 2);
		motor(2, (50 - analog(2)) * 2);
		
		timerPause(100);
	}
}

