//*****************************************************************************
// File Name	: encodertest.c
// 
// Title		: example usage of encoder driver functions
// Revision		: 2.3
// Notes		:
// Target MCU	: Atmel AVR mega32 (KR-mega32-16v20)
// Editor Tabs	: 4
// 
// Revision History:
// When			Who			Description of change
// -----------	-----------	-----------------------
// 10-Dez-2004	krat		Created the program
//*****************************************************************************

/*
			Funktionsbeschreibung
	
Das Programm liest Radencoder aus und gibt das Ergebnis auf die serielle Schnittstelle aus.
Das Programm ist fr Radencoder mit zwei um 90 versetzten Kanlen geschrieben. 
Damit lsst sich auch die Richtung der Drehbewegung erfassen. 
Pinbelegung der Encoder am KR-mega32-16v23:

Portbelegung Radencoder 0:
Kanal A an Interrupteingang 0
Kanal B an Digitalport 16


Portbelegung Radencoder 1:
Kanal A an Interrupteingang 1
Kanal B an Digitalport 15

Portbelegung Radencoder 2:
Kanal A an Interrupteingang 2
Kanal B an Digitalport 14

Es knnen aber auch einfache Encoder verwendet werden. Sie werden genauso angeschlossen, 
wie die normalen Encoder, nur dass fr den fehlenden Kanal B der entsprechende Digitalport 
auf High gelegt wird.

Um die Radencoderstnde am PC lesen zu knnen, brauchen Sie nur das Board ber die serielle
Verbindung anzuschlieen und das Hyperterminal fr das KR-mega32-16v23 zu starten, 
wie in der Installationsanleitung beschrieben.

Viel Erfolg

Thomas Krause (krat)
Krause Robotik

mailto: thomas.krause@krause-robotik.de

*/


//----- Include Files ---------------------------------------------------------
#include "kr-mega32v23.h"

void encoderTest(void);

//----- Begin Code ------------------------------------------------------------
int main(void)
{
	// initialize our libraries
	//initialize the UART (serial port)
	uartInit();
	// set the baud rate of the UART for our debug/reporting output
	uartSetBaudRate(9600);
	// initialize the LCD
	lcdInit();
	
	// initialize the timer system
	timerInit();
	// initialize rprintf system for LCD-Output
	rprintfInit(lcdDataWrite);
	rprintf("Encodertest       ");
	// initialize vt100 library
	vt100Init();

	// initialize rprintf system for serial out
	rprintfInit(uartSendByte);

	// clear the terminal screen
	vt100ClearScreen();
	
	// run the test
	encoderTest();

	return 0;
}

void encoderTest(void)
{
	// initialize the encoders
	encoderInit();

	// print a little intro message so we know things are working
	rprintf("\r\nEncodertest!\r\n");

	// report encoder position continuously
	while(1)
	{
		//lcdGotoXY(0, 0);
		rprintfProgStrM("Enc0:");
		// print encoder0 position
		// use base-10, 10 chars, signed, pad with spaces
		rprintfNum(10, 10, TRUE, ' ', encoderGetPosition(0));
		//lcdGotoXY(0, 1);
		rprintfProgStrM(" Enc1:");
		// print encoder1 position
		// use base-10, 10 chars, signed, pad with spaces
		rprintfNum(10, 10, TRUE, ' ', encoderGetPosition(1));
		
		rprintfProgStrM(" Enc2:");
		// print encoder1 position
		// use base-10, 10 chars, signed, pad with spaces
		rprintfNum(10, 10, TRUE, ' ', encoderGetPosition(2));

		// print carriage return and line feed
		rprintfCRLF();
	}
}

