//*****************************************************************************
// File Name	: uarttest.c
// 
// Title		: test usage of uart library functions
// Revision		: 2.3
// Notes		:	
// Target MCU	: Atmel AVR mega32 (KR-mega32-16v20)
// Editor Tabs	: 4
// 
// Revision History:
// When			Who			Description of change
// -----------	-----------	-----------------------
// 04-Dez-2004	krat		Created the program
//*****************************************************************************

 
//----- Include Files ---------------------------------------------------------
#include "kr-mega32v23.h"
int uarttest(void);

int main(void)
{
	// initialize our library
	// initialize the UART
	uartInit();
	// set the baudrate
	uartSetBaudRate(9600);
	// initialize the timer
	timerInit();
	// initialize the CLD
	lcdInit();
	// set the bus speed (kHz)
	lcdSetSpeed(300);
	
	rprintfInit(lcdDataWrite);
	
	rprintf("UART Test");

	uarttest();


	return 0;
}

int uarttest(void)
{
	u08 data;
	
	rprintfInit(uartSendByte);
	rprintf("\n Willkommen zum Verbindungstest");
	rprintf("\n");
	rprintf("\r\n Die Kommunikation zum PC funktioniert bereits.");
	rprintf("\r\n Was Sie Jetzt auf der Tastatur eingeben, sollte auf dem");
	rprintf("\r\n LC-Display des KR-mega32-16 erscheinen.");
	rprintf("\r\n Die Taste '.' gringt den Kursor an den Zeilenanfang der ersten Zeile.");
	rprintf("\r\n Die Taste ',' gringt den Kursor an den Zeilenanfang der zweiten Zeile.");
	rprintf("\r\n Viel Spass beim Ausprobieren.");
	
	rprintfInit(lcdDataWrite);
	lcdGotoXY(0, 0);

	while(1)
	{
		// wait until something received over UART
		while(uartReceiveBufferIsEmpty());
		uartReceiveByte(&data);
		
		if (data == 44) lcdGotoXY(0, 1);
		else if (data == 46) lcdGotoXY(0, 0);
		else rprintf("%c", data);
		uartFlushReceiveBuffer();
	}
	
	
	return 0;
}