#include "motordef.h"



void setze(void)
{
	if (motor1Direction == 1) cbi(MOTOR1DIRECTION_PORT, MOTOR1DIRECTION_PIN);
	else sbi(MOTOR1DIRECTION_PORT, MOTOR1DIRECTION_PIN);
	
	if (motor2Direction == 1) cbi(MOTOR2DIRECTION_PORT, MOTOR2DIRECTION_PIN);
	else sbi(MOTOR2DIRECTION_PORT, MOTOR2DIRECTION_PIN);
	
	motorCount++;
	
		if (motorCount > 0 && motorCount < motor1Power)
	{
		sbi(MOTOR1PWM_PORT, MOTOR1PWM_PIN);
	}
	else
	{
		cbi(MOTOR1PWM_PORT, MOTOR1PWM_PIN);
	}
	
	
	if (motorCount > 0 && motorCount < motor2Power)
	{
		sbi(MOTOR2PWM_PORT, MOTOR2PWM_PIN);
	}
	else
	{
		cbi(MOTOR2PWM_PORT, MOTOR2PWM_PIN);
	}
	
	if (motorCount > 100) motorCount = 0;

}

void motorInit(void)
{
	motor1Power = 0;
	motor2Power = 0;
	motor1Direction = 1;
	motor2Direction = 1;
	
	//set the output for motor 1
	sbi(DDRD, 5);
	sbi(DDRD, 7);
	//set the output for motor 2
	sbi(DDRD, 4);
	sbi(DDRD, 6);
	
	timerInit();
	timer0SetPrescaler(TIMERRTC_CLK_DIV8);
    timerAttach(TIMER0OVERFLOW_INT, setze);
}

void motor(int port, int power)
{
	if (port < 3 && port > 0)
	{
		if (power > 100) power = 100;
		if (power < -100) power = -100;
		
		if (power >= 0)
		{
			if (port == 1)
			{
				motor1Direction = 1;
				motor1Power = power;
			}
			else
			{
				motor2Direction = 1;
				motor2Power = power;
			}
		}
		else
		{
			if (port == 1)
			{
				motor1Direction = 0;
				motor1Power = -power;
			}
			else
			{
				motor2Direction = 0;
				motor2Power = -power;
			}
		}
	
	}
}

void motorStop(int port)
{
	if (port == 1) motor1Power = 0;
	else motor2Power = 0;
}
