#include "ports.h"
#include "a2d.h"
#include "i2c.h"

unsigned char portBuffer[3];
unsigned char portBufferLength = 0x03;


// ------------------- access to analog ports ------------------------------
int analog(int port)
{
	if (port > 8 || port < 1) return 0;
	else return (int)(a2dConvert8bit(port - 1));
}


// ------------------ access to digital out --------------------------------
// clear an output
void clearDigitalOut(int port)
{
	switch (port)
	{
		case 1: outb(DDRA, inb(DDRA) | 1);
				outb(PORTA, inb(PORTA) & ~1);
				break;
		case 2: outb(DDRA, inb(DDRA) | 2);
				outb(PORTA, inb(PORTA) & ~2);
				break;
		case 3: outb(DDRA, inb(DDRA) | 4);
				outb(PORTA, inb(PORTA) & ~4);
				break;
		case 4: outb(DDRA, inb(DDRA) | 8);
				outb(PORTA, inb(PORTA) & ~8);
				break;
		case 5: outb(DDRA, inb(DDRA) | 16);
				outb(PORTA, inb(PORTA) & ~16);
				break;
		case 6: outb(DDRA, inb(DDRA) | 32);
				outb(PORTA, inb(PORTA) & ~32);
				break;
		case 7: outb(DDRA, inb(DDRA) | 64);
				outb(PORTA, inb(PORTA) & ~64);
				break;
		case 8: outb(DDRA, inb(DDRA) | 128);
				outb(PORTA, inb(PORTA) & ~128);
				break;
				
		case 9: outb(DDRB, inb(DDRB) | 2);
				outb(PORTB, inb(PORTB) & ~2);
				break;
		case 10: outb(DDRB, inb(DDRB) | 1);
				outb(PORTB, inb(PORTB) & ~1);
				break;

		case 11: outb(DDRC, inb(DDRC) | 128);
				outb(PORTC, inb(PORTC) & ~128);
				break;
		case 12: outb(DDRC, inb(DDRC) | 64);
				outb(PORTC, inb(PORTC) & ~64);
				break;
		case 13: outb(DDRC, inb(DDRC) | 32);
				outb(PORTC, inb(PORTC) & ~32);
				break;
		case 14: outb(DDRC, inb(DDRC) | 16);
				outb(PORTC, inb(PORTC) & ~16);
				break;
		case 15: outb(DDRC, inb(DDRC) | 8);
				outb(PORTC, inb(PORTC) & ~8);
				break;
		case 16: outb(DDRC, inb(DDRC) | 4);
				outb(PORTC, inb(PORTC) & ~4);
				break;
		case 17: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~8;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~8;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 18: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~16;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~16;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 19: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~32;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~32;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 20: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~64;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~64;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 21: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~128;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~128;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
	}
}

//set an output
void setDigitalOut(int port)
{
	switch (port)
	{
		case 1: outb(DDRA, inb(DDRA) | 1);
				outb(PORTA, inb(PORTA) | 1);
				break;
		case 2: outb(DDRA, inb(DDRA) | 2);
				outb(PORTA, inb(PORTA) | 2);
				break;
		case 3: outb(DDRA, inb(DDRA) | 4);
				outb(PORTA, inb(PORTA) | 4);
				break;
		case 4: outb(DDRA, inb(DDRA) | 8);
				outb(PORTA, inb(PORTA) | 8);
				break;
		case 5: outb(DDRA, inb(DDRA) | 16);
				outb(PORTA, inb(PORTA) | 16);
				break;
		case 6: outb(DDRA, inb(DDRA) | 32);
				outb(PORTA, inb(PORTA) | 32);
				break;
		case 7: outb(DDRA, inb(DDRA) | 64);
				outb(PORTA, inb(PORTA) | 64);
				break;
		case 8: outb(DDRA, inb(DDRA) | 128);
				outb(PORTA, inb(PORTA) | 128);
				break;
				
		case 9: outb(DDRB, inb(DDRB) | 2);
				outb(PORTB, inb(PORTB) | 2);
				break;
		case 10: outb(DDRB, inb(DDRB) | 1);
				outb(PORTB, inb(PORTB) | 1);
				break;

		case 11: outb(DDRC, inb(DDRC) | 128);
				outb(PORTC, inb(PORTC) | 128);
				break;
		case 12: outb(DDRC, inb(DDRC) | 64);
				outb(PORTC, inb(PORTC) | 64);
				break;
		case 13: outb(DDRC, inb(DDRC) | 32);
				outb(PORTC, inb(PORTC) | 32);
				break;
		case 14: outb(DDRC, inb(DDRC) | 16);
				outb(PORTC, inb(PORTC) | 16);
				break;
		case 15: outb(DDRC, inb(DDRC) | 8);
				outb(PORTC, inb(PORTC) | 8);
				break;
		case 16: outb(DDRC, inb(DDRC) | 4);
				outb(PORTC, inb(PORTC) | 4);
				break;
		case 17: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~8;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 8;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 18: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~16;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 16;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 19: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~32;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 32;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 20: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~64;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 64;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;
		case 21: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] &= ~128;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 3;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 128;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				break;

	}
	
}


//set an output
int digital(int port)
{
	int wert = 0;
	switch (port)
	{
		case 1: DDRA &= ~1;
				if (PINA & 1) wert = 1;
				else wert = 0;
				break;
		case 2: DDRA &= ~2;
				if (PINA & 2) wert = 1;
				else wert = 0;
				break;
		case 3: DDRA &= ~4;
				if (PINA & 4) wert = 1;
				else wert = 0;
				break;
		case 4: DDRA &= ~8;
				if (PINA & 8) wert = 1;
				else wert = 0;
				break;
		case 5: DDRA &= ~16;
				if (PINA & 16) wert = 1;
				else wert = 0;
				break;
		case 6: DDRA &= ~32;
				if (PINA & 32) wert = 1;
				else wert = 0;
				break;
		case 7: DDRA &= ~64;
				if (PINA & 64) wert = 1;
				else wert = 0;
				break;
		case 8: DDRA &= ~128;
				if (PINA & 128) wert = 1;
				else wert = 0;
				break;

		case 9: DDRB &= ~2;
				if (PINB & 2) wert = 1;
				else wert = 0;
				break;
		case 10: DDRB &= ~1;
				if (PINB & 1) wert = 1;
				else wert = 0;
				break;
				
		case 11: DDRC &= ~128;
				if (inb(PINC) & 128) wert = 1;
				else wert = 0;
				break;
		case 12: DDRC &= ~64;
				if (inb(PINC) & 64) wert = 1;
				else wert = 0;
				break;
		case 13: DDRC &= ~32;
				if (inb(PINC) & 32) wert = 1;
				else wert = 0;
				break;
		case 14: DDRC &= ~16;
				if (inb(PINC) & 16) wert = 1;
				else wert = 0;
				break;
		case 15: DDRC &= ~8;
				if (inb(PINC) & 8) wert = 1;
				else wert = 0;
				break;
		case 16: DDRC &= ~4;
				if (inb(PINC) & 4) wert = 1;
				else wert = 0;
				break;
		case 17: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 8;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 1;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				if (portBuffer[1] & 8) wert = 1;
				else wert = 0;
				break;
		case 18: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 16;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 1;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				if (portBuffer[1] & 16) wert = 1;
				else wert = 0;
				break;
		case 19: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 32;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 1;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				if (portBuffer[1] & 32) wert = 1;
				else wert = 0;
				break;
		case 20: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 64;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 1;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				if (portBuffer[1] & 64) wert = 1;
				else wert = 0;
				break;
		case 21: portBuffer[0] = 7;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				portBuffer[1] |= 128;
				i2cMasterSend(LCD_I2C_ADRESS, portBufferLength, portBuffer);
				portBuffer[0] = 1;
				i2cMasterSend(LCD_I2C_ADRESS, 0x01, portBuffer);
				i2cMasterReceive(LCD_I2C_ADRESS, portBufferLength - 0x01, &portBuffer[1]);
				if (portBuffer[1] & 128) wert = 1;
				else wert = 0;
				break;
	}
	return wert;
}

