//*****************************************************************************
// File Name	: encodertest.c
// 
// Title		: example usage of encoder driver functions
// Revision		: 1.1
// Notes		:
// Target MCU	: Atmel AVR mega32
// Editor Tabs	: 4
// 
// Revision History:
// When			Who			Description of change
// -----------	-----------	-----------------------
// 27-Jan-2003	pstang		Created the program
// 17-Jan-2005  krat		Modification for kr-mega32-16v20
//*****************************************************************************


//----- Include Files ---------------------------------------------------------
#include "kr-mega32v21.h"

void encoderTest(void);

//----- Begin Code ------------------------------------------------------------
int main(void)
{
	// initialize our libraries
	//initialize the UART (serial port)
	uartInit();
	// set the baud rate of the UART for our debug/reporting output
	uartSetBaudRate(9600);
	lcdInit();
	
	// initialize the timer system
	timerInit();
	// initialize rprintf system
	rprintfInit(lcdDataWrite);
	rprintf("Encodertest       ");
	// initialize vt100 library
	vt100Init();

	rprintfInit(uartSendByte);

	// clear the terminal screen
	vt100ClearScreen();
	
	// run the test
	encoderTest();

	return 0;
}

void encoderTest(void)
{
	// initialize the encoders 
	encoderInit();

	// print a little intro message so we know things are working
	rprintf("\r\nEncodertest!\r\n");

	// report encoder position continuously
	while(1)
	{
		//lcdGotoXY(0, 0);
		rprintfProgStrM("Enc0:");
		// print encoder0 position
		// use base-10, 10 chars, signed, pad with spaces
		rprintfNum(10, 10, TRUE, ' ', encoderGetPosition(0));
		//lcdGotoXY(0, 1);
		rprintfProgStrM(" Enc1:");
		// print encoder1 position
		// use base-10, 10 chars, signed, pad with spaces
		rprintfNum(10, 10, TRUE, ' ', encoderGetPosition(1));
		
		rprintfProgStrM(" Enc2:");
		// print encoder1 position
		// use base-10, 10 chars, signed, pad with spaces
		rprintfNum(10, 10, TRUE, ' ', encoderGetPosition(2));

		// print carriage return and line feed
		rprintfCRLF();
	}
}

